<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Setting;

use Erlage\Photogram\Data\Models\AbstractFinder;
use Erlage\Photogram\Data\Tables\Setting\SettingTable;

final class SettingFinder extends AbstractFinder implements InterfaceSettingSetter
{
    /**
     * setter interface
     */
    use TraitSettingSetters;

    public function getTableName(): string
    {
        return SettingTable::getTableName();
    }

    /**
     * @return mixed 
     */
    public function getAtrributeValue(string $attribute)
    {
        return $this -> {SettingTable::CAMEL_CASE_MAP[$attribute]}
        ?? null;
    }

    public function popModelFromResults(): SettingModel
    {
        return SettingModel::createFromUntouchedBean_noException(parent::pop());
    }
}
